/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.Random;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blockentities.RiftStabilizerBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.network.client.OpenScreen;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class RiftStabilizerBlock
extends DisguisableBlock {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyEnum<BlockDoor.EnumDoorHalf> HALF = BlockDoor.field_176523_O;
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    private static final AxisAlignedBB SHAPE_UPPER = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.5, 0.875);

    public RiftStabilizerBlock(Material material) {
        super(material);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(HALF, (Comparable)BlockDoor.EnumDoorHalf.LOWER).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
        this.destroyTimeForOwner = 5.0f;
        this.setHarvestLevel("pickaxe", 1);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
            BlockUtils.updateIndirectNeighbors(world, pos, (Block)this);
        }
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState actualState = this.getDisguisedBlockState(world.func_175625_s(pos));
        if (actualState != null && actualState.func_177230_c() != this) {
            return actualState.func_185900_c(world, pos);
        }
        return state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.UPPER ? SHAPE_UPPER : Block.field_185505_j;
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        RiftStabilizerBlockEntity riftStabilizer;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof RiftStabilizerBlockEntity && (riftStabilizer = (RiftStabilizerBlockEntity)te).isOwnedBy((Entity)player)) {
            if (!world.field_72995_K) {
                if (riftStabilizer.isDisabled()) {
                    player.func_146105_b((ITextComponent)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
                } else {
                    SecurityCraft.network.sendTo((IMessage)new OpenScreen(OpenScreen.DataType.RIFT_STABILIZER, pos), (EntityPlayerMP)player);
                }
            }
            return true;
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.UPPER) {
            BlockPos lowerPos = pos.func_177977_b();
            IBlockState lowerState = world.func_180495_p(lowerPos);
            if (lowerState.func_177230_c() != this) {
                world.func_175698_g(pos);
            } else if (block != this) {
                lowerState.func_189546_a(world, lowerPos, block, fromPos);
            }
        } else {
            BlockPos upperPos = pos.func_177984_a();
            IBlockState upperState = world.func_180495_p(upperPos);
            if (upperState.func_177230_c() != this) {
                if (!world.field_72995_K) {
                    RiftStabilizerBlockEntity be;
                    ItemStack dropStack = new ItemStack(Item.func_150898_a((Block)this), 1);
                    TileEntity tileEntity = world.func_175625_s(pos);
                    if (tileEntity instanceof RiftStabilizerBlockEntity && (be = (RiftStabilizerBlockEntity)tileEntity).func_145818_k_()) {
                        dropStack.func_151001_c(be.func_70005_c_());
                    }
                    RiftStabilizerBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)dropStack);
                }
                world.func_175698_g(pos);
            }
        }
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return super.func_176196_c(world, pos) && pos.func_177956_o() < world.func_72800_K() - 1 && world.func_180495_p(pos.func_177984_a()).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177984_a());
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand).func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        BlockPos posAbove = pos.func_177984_a();
        world.func_180501_a(posAbove, this.func_176223_P().func_177226_a(HALF, (Comparable)BlockDoor.EnumDoorHalf.UPPER), 3);
        if (placer instanceof EntityPlayer) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, posAbove, (EntityPlayer)placer));
        }
        super.func_180633_a(world, pos, state, placer, stack);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntity te;
        BlockPos lowerPos = pos.func_177977_b();
        BlockPos upperPos = pos.func_177984_a();
        if (player.func_184812_l_() && (te = world.func_175625_s(pos)) instanceof IModuleInventory) {
            ((IModuleInventory)te).getInventory().clear();
        }
        if (player.field_71075_bZ.field_75098_d && state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.UPPER && world.func_180495_p(lowerPos).func_177230_c() == this) {
            world.func_175698_g(lowerPos);
        }
        if (state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.LOWER && world.func_180495_p(upperPos).func_177230_c() == this) {
            if (player.field_71075_bZ.field_75098_d) {
                world.func_175698_g(pos);
            }
            world.func_175698_g(upperPos);
        }
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() + ((Boolean)state.func_177229_b((IProperty)POWERED) != false ? 4 : 0) + (state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.UPPER ? 8 : 0);
    }

    public IBlockState func_176203_a(int meta) {
        BlockDoor.EnumDoorHalf half = meta >= 8 ? BlockDoor.EnumDoorHalf.UPPER : BlockDoor.EnumDoorHalf.LOWER;
        boolean powered = (meta & 4) > 0;
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta)).func_177226_a(HALF, (Comparable)half).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(powered));
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.UPPER ? Items.field_190931_a : Item.func_150898_a((Block)this);
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity te = world.func_175625_s(pos);
        return (Boolean)state.func_177229_b((IProperty)POWERED) != false && state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.LOWER && te instanceof RiftStabilizerBlockEntity ? 15 - (int)((RiftStabilizerBlockEntity)te).getLastTeleportDistance() : 0;
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.func_180656_a(state, world, pos, side);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.LOWER && te instanceof RiftStabilizerBlockEntity) {
            RiftStabilizerBlockEntity riftStabilizer = (RiftStabilizerBlockEntity)te;
            return riftStabilizer.isModuleEnabled(ModuleType.REDSTONE) && riftStabilizer.getLastTeleportationType() != null ? riftStabilizer.getComparatorOutputFunction().applyAsInt(riftStabilizer.getLastTeleportationType()) : 0;
        }
        return 0;
    }

    public static RiftStabilizerBlockEntity getConnectedTileEntity(World level, BlockPos pos) {
        IBlockState state = level.func_180495_p(pos);
        BlockPos connectedPos = state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.LOWER ? pos.func_177984_a() : pos.func_177977_b();
        TileEntity te = level.func_175625_s(connectedPos);
        return te instanceof RiftStabilizerBlockEntity ? (RiftStabilizerBlockEntity)te : null;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, HALF, POWERED});
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new RiftStabilizerBlockEntity();
    }
}

